<div class="card border border-warning">

    <div class="card-body">
        <h4 class="card-title"><i class="mdi mdi-plus-circle"></i> Tambah Pasaran</h4>

        <button onclick="openPopupPasaran()" type="button" class="btn btn-primary">Add Pasaran</button>
    </div>

</div>

<div id="popuppasaran">
    <div class="bg-overlay-pasaran"></div>
    <div style="width: 100%; z-index: 555; display: flex; justify-content: center;">

        <form method="POST" action="config/add-pasaran.php" class=" popup-add-pasaran">
            <h4 class="card-title"><i class="mdi mdi-plus-circle"></i> Tambah Pasaran</h4>

            <button type="button" onclick="closePopupPasaran()" class="close-button-popup">X</button>
            <input class="form border border-primary my-2 form-control" type="text" name="namapasaran" placeholder="Nama Pasaran" required />
            <input class="form border border-primary my-2 form-control" type="text" name="gambarpasaran" placeholder="Gambar Pasaran" required />
            <input class="form border border-primary my-2 form-control" type="text" name="linklivedraw" placeholder="Link Livedraw Pasaran" required />
            <input type="text" placeholder="Jam tutup Pasaran Contoh : 01:00:00" name="jamtutuppasaran" maxlength="8" class="form-control border border-primary my-2">
            <input type="text" placeholder="Jam result Pasaran Contoh : 01:00:00" name="jamresultpasaran" maxlength="8" class="form-control border border-primary my-2">

            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-primary my-2">Submit</button>
            </div>
        </form>
    </div>
</div>

<?php

$results_per_page = 25;
$sql = "SELECT * FROM pasaran_web";
$result = mysqli_query($data, $sql);
$number_of_results = mysqli_num_rows($result);

$number_of_pages = ceil($number_of_results / $results_per_page);

if (!isset($_GET['no'])) {
    $page = 1;
} else {
    $page = $_GET['no'];
}

$this_page_first_result = ($page - 1) * $results_per_page;

$smar = "SELECT * FROM pasaran_web LIMIT " . $this_page_first_result . " ," . $results_per_page;
$qmar = mysqli_query($data, $smar);

if (mysqli_num_rows($qmar) > 0) {
    $x = 1;
    while ($fmar = mysqli_fetch_assoc($qmar)) {
        $market = $fmar['nama_pasaranweb'];
        $ptext = $fmar['prediksi_texts'];
        $linklive = $fmar['link_livedraw'];
        $jamtutup = $fmar['jam_tutuppas'];
        $jamundi = $fmar['jam_undipass'];
        $idmar = $fmar['id'];
        $gambar_market = empty($fmar['gambar_pasaran']) ? 'assets/images/icon-market/' . $market . '.webp' : $fmar['gambar_pasaran'];

        echo '<div>
            <div class="card border mb-2 border-info">
                <form method="POST" action="config/update-jptxt.php?row=' . $idmar . '" class="form-horizontal">
                    <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                                            <h4 class="card-title text-uppercase"><img class="rounded" src="' . $gambar_market . '" width="50" /> ' . $x++ . '. ' . $market . '</h4>
                                            <button onclick="deletePasaran(\'' . $fmar['id'] . '\', \'' . $market . '\')" class="btn btn-sm btn-danger" type="button">Delete Pasaran</button>
                </div>

                    <div class="row form-group">

                                <div class="col-3">
                                        <p class="mb-1"><i class="fas fa-globe"></i> Link Livedraw:</p>
                                    <input type="text" name="linklive" value="' . $linklive . '" class="form-control">
                                    </div>

                                    <div class="col-3">
                                        <p class="mb-1"><i class="fas fa-globe"></i> Link Gambar:</p>
                                    <input type="text" name="gambarlive" value="' . $fmar['gambar_pasaran'] . '" class="form-control">
                                    </div>

                                    <div class="col-3">
                                        <p class="mb-1"><i class="fas fa-clock"></i> Tutup Pasaran:</p>
                                    <input type="text" placeholder="Contoh : 01:00:00" name="jmttp" maxlength="8" value="' . $jamtutup . '" class="form-control">
                                    </div>

                                    <div class="col-3">
                                        <p class="mb-1"><i class="fas fa-clock"></i> Result Pasaran:</p>
                                    <input type="text" name="jmundi" placeholder="Contoh : 01:00:00" maxlength="8" value="' . $jamundi . '" class="form-control">
                                    </div>
                            </div>
                            <small>Upload gambar? langsung ke link ini >>> <a href="https://id.imgbb.com/" target="_blank">IMGBB</a></small>
                            <textarea class="editor" name="jp-text" style="height: 300px; width: 100%;">' . html_entity_decode($ptext) . '</textarea>

                            <button type="submit" class="btn mt-3 btn-block btn-primary">Submit</button>

                            </form>
                     </div>
            </div> ';
    }
}

?>

<div class="row">
    <div class="col-12">
        <div>
            <nav>
                <ul class="pagination" style="display: flex; justify-content: flex-end; flex-wrap: wrap;">
                    <?php
                    // display the links to the pages
                    for ($page = 1; $page <= $number_of_pages; $page++) {
                        echo ' <li class="page-item"><a class="page-link font-weight-bold" href="?hal=daftarpasaran&no=' . $page . '">' . $page . '</a></li>';
                    }

                    ?>

                </ul>
            </nav>
        </div>
    </div>
</div>

<?php
if (!isset($_SESSION['nama_pengguna'])) {
    echo '<script>
        window.location.replace("/");
        </script>';
}
?>

<style>
    #popuppasaran {
        display: none;
    }

    .popup-add-pasaran {
        background: #fff;
        padding: 2rem;
        position: fixed;
        z-index: 2;
        width: 70%;
        border-radius: 1rem;
    }

    .bg-overlay-pasaran {
        background: rgb(0, 0, 0, 0.8);
        width: 100%;
        height: 100vh;
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1;
    }

    .close-button-popup {
        background: red;
        color: white;
        border: none;
        font-weight: bold;
        font-size: 1.2rem;
        border-radius: 1rem;
        position: absolute;
        padding: 0.2rem 0.7rem;
        top: -.6rem;
        cursor: pointer;
        right: -0.3rem;
    }
</style>

<script>
    const getPopup = document.getElementById('popuppasaran');

    function openPopupPasaran() {
        getPopup.style.display = 'block'
    }

    function closePopupPasaran() {
        getPopup.style.display = ''
    }

    function deletePasaran(token, market) {
        const confirmDelete = confirm(`Apakah Yakin ingin Hapus Pasaran ${market}?`);

        if (confirmDelete) {
            $.ajax({
                type: 'POST',
                url: 'config/delete-pasaran.php',
                data: {
                    token: token,
                    market: market
                },
                success: ((response) => {
                    alert(response);
                    location.reload()
                }),
                error: (() => alert('System Gagal Dalam Menghapus Pasaran')),
            })

        }
    }
</script>